/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWAssignmentsTableModel;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWFieldNameCellEditor;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWStepAssignmentsSubPanel
extends JPanel
implements ActionListener,
IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWPropertyChangeSource {
    protected static final int TYPE_PRE = 0;
    protected static final int TYPE_POST = 1;
    private VWStepDefinition m_stepDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private Vector m_changedItems = null;
    private boolean m_firstTime = true;
    private int m_nType = -1;
    private JComboBox m_milestoneCombo = null;
    private VWToolbarBorder m_toolbarBorder = null;
    private JScrollPane m_assignmentsScrollPane = null;
    private VWTable m_assignmentsTable = null;
    private VWAssignmentsTableModel m_assignmentsTableModel = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    public VWStepAssignmentsSubPanel(VWAuthPropertyData authPropertyData, int nType) {
        this.m_authPropertyData = authPropertyData;
        this.m_nType = nType;
        this.createControls();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_firstTime) {
            this.m_firstTime = false;
            if (this.m_assignmentsTable != null) {
                this.m_assignmentsTable.fitColumnsInTable();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_milestoneCombo) {
                this.performMilestoneAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (this.m_assignmentsTable == null || this.m_assignmentsTableModel == null) {
            return;
        }
        this.stopEditing();
        switch (event.getID()) {
            case 1: {
                this.onUp();
                break;
            }
            case 2: {
                this.onDown();
                break;
            }
            case 0x10000000: {
                this.m_assignmentsTableModel.deleteItem(this.m_assignmentsTable.getSelectedRow());
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (this.m_assignmentsTable == null) break;
                if (nRow == this.m_assignmentsTable.getSelectedRow()) {
                    this.m_assignmentsTable.clearSelection();
                }
                this.m_assignmentsTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        int nRowCount;
        if (event.getValueIsAdjusting()) {
            return;
        }
        JPanel source = this.m_toolbarBorder.getClientPanel();
        int nControls = 0x10000003;
        this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, nControls));
        int nRowIndex = this.m_assignmentsTable.getSelectedRow();
        if (this.m_assignmentsTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_assignmentsTableModel.getRowCount()) - 1) {
            if (nRowIndex > 0) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 1));
            } else {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 1));
            }
            if (nRowIndex < nRowCount - 2) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 2));
            } else {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 2));
            }
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 0x10000000));
        }
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 524);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public void setSelectedStep(VWStepDefinition newStepDefinition) {
        if (this.m_stepDefinition != null && this.m_stepDefinition == newStepDefinition) {
            return;
        }
        this.m_stepDefinition = newStepDefinition;
        this.reinitialize();
    }

    protected void stopEditing() {
        if (this.m_assignmentsTable != null) {
            this.m_assignmentsTable.stopEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitialize() {
        if (this.m_authPropertyData == null) {
            return;
        }
        try {
            if (this.m_milestoneCombo != null) {
                this.m_milestoneCombo.removeActionListener(this);
                this.m_milestoneCombo.removeAllItems();
                this.m_milestoneCombo.addItem(VWResource.s_noneItemStr);
                VWMilestoneDefinition[] milestoneDefs = this.m_authPropertyData.getMilestones();
                if (milestoneDefs != null && milestoneDefs.length > 0) {
                    Object[] milestoneNames = new String[milestoneDefs.length];
                    for (int i = 0; i < milestoneDefs.length; ++i) {
                        String milestoneName = milestoneDefs[i].getName();
                        milestoneNames[i] = milestoneName;
                    }
                    VWQuickSort milestoneNameSort = new VWQuickSort(milestoneNames, 0);
                    milestoneNameSort.sort(0, milestoneNames.length - 1);
                    for (int i = 0; i < milestoneNames.length; ++i) {
                        this.m_milestoneCombo.addItem(milestoneNames[i]);
                    }
                    String milestoneName = null;
                    switch (this.m_nType) {
                        case 0: {
                            milestoneName = this.m_stepDefinition.getPreMilestone();
                            break;
                        }
                        case 1: {
                            milestoneName = this.m_stepDefinition.getPostMilestone();
                        }
                    }
                    if (milestoneName != null) {
                        this.m_milestoneCombo.setSelectedItem(milestoneName);
                    }
                }
            }
            this.m_assignmentsTableModel.setSelectedStep(this.m_stepDefinition, this.m_nType);
            this.m_assignmentsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            if (this.m_milestoneCombo != null) {
                this.m_milestoneCombo.addActionListener(this);
            }
        }
    }

    protected void releaseReferences() {
        if (this.m_milestoneCombo != null) {
            this.m_milestoneCombo.removeActionListener(this);
            this.m_milestoneCombo.removeAllItems();
            this.m_milestoneCombo = null;
        }
        if (this.m_toolbarBorder != null) {
            this.m_toolbarBorder.removeToolbarBorderActionNotifier(this);
            this.m_toolbarBorder.releaseReferences();
            this.m_toolbarBorder = null;
        }
        if (this.m_assignmentsScrollPane != null) {
            this.m_assignmentsScrollPane.removeAll();
            this.m_assignmentsScrollPane = null;
        }
        if (this.m_assignmentsTable != null) {
            this.m_assignmentsTable.getSelectionModel().removeListSelectionListener(this);
            this.m_assignmentsTable.removeAll();
            this.m_assignmentsTable = null;
        }
        if (this.m_assignmentsTableModel != null) {
            this.m_assignmentsTableModel.releaseReferences();
            this.m_assignmentsTableModel = null;
        }
        if (this.m_changedItems != null) {
            this.m_changedItems.removeAllElements();
            this.m_changedItems = null;
        }
        this.m_stepDefinition = null;
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.3;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 5, 0, 20);
            this.add((Component)this.getMilestonesPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            this.add((Component)this.getAssignmentsTablePanel(), gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 0.2;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMilestonesPanel() {
        try {
            VWToolbarBorder milestonesBorder = new VWToolbarBorder(VWResource.s_milestoneStr, 0x40000000);
            JPanel clientPanel = milestonesBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_milestoneCombo = new JComboBox();
            this.m_milestoneCombo.setName("m_milestoneCombo_VWStepAssignmentsTab");
            this.m_milestoneCombo.setModel(new DefaultComboBoxModel());
            this.m_milestoneCombo.setRenderer(this.m_customComboBoxRenderer);
            this.m_milestoneCombo.addActionListener(this);
            clientPanel.add((Component)this.m_milestoneCombo, "First");
            return milestonesBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getAssignmentsTablePanel() {
        try {
            this.m_toolbarBorder = new VWToolbarBorder(VWResource.s_fieldAssignmentsStr, 0x10000003);
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            JPanel clientPanel = this.m_toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_assignmentsTableModel = new VWAssignmentsTableModel(this.m_authPropertyData, this.m_stepDefinition);
            this.m_assignmentsTableModel.addTableModelListener(this);
            this.m_assignmentsTable = new VWTable(this.m_assignmentsTableModel);
            this.m_assignmentsTable.setName("m_preAssignmentsTable_VWStepAssignmentsTab");
            this.m_assignmentsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_assignmentsTable.setRowSelectionAllowed(true);
            this.m_assignmentsTable.getSelectionModel().addListSelectionListener(this);
            this.m_assignmentsTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_assignmentsTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellEditor(new VWFieldNameCellEditor(this.m_authPropertyData));
            }
            if ((tcElement = this.m_assignmentsTable.getColumnModel().getColumn(1)) != null) {
                tcElement.setCellEditor(new VWExpressionCellEditor(this.m_authPropertyData));
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            this.m_assignmentsScrollPane = new JScrollPane(this.m_assignmentsTable);
            this.m_assignmentsScrollPane.setName("m_preAssignmentScrollPane_VWStepAssignmentsTab");
            clientPanel.add((Component)this.m_assignmentsScrollPane, "Center");
            return this.m_toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void performMilestoneAction() {
        try {
            if (this.m_stepDefinition == null) {
                return;
            }
            String milestoneName = (String)this.m_milestoneCombo.getSelectedItem();
            boolean bIsNone = VWStringUtils.compare(milestoneName, VWResource.s_noneItemStr) == 0;
            switch (this.m_nType) {
                case 0: {
                    this.m_stepDefinition.setPreMilestone(bIsNone ? null : milestoneName);
                    break;
                }
                case 1: {
                    this.m_stepDefinition.setPostMilestone(bIsNone ? null : milestoneName);
                }
            }
            this.m_authPropertyData.setDirty();
            this.m_changedItems = new Vector();
            this.m_changedItems.addElement(this.m_stepDefinition);
            this.notifyPropertyChange();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUp() {
        try {
            int nRowIndex = this.m_assignmentsTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_assignmentsTableModel.up(nRowIndex);
                this.m_assignmentsTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDown() {
        try {
            int nRowIndex = this.m_assignmentsTable.getSelectedRow();
            if (nRowIndex < this.m_assignmentsTableModel.getRowCount() - 2) {
                this.m_assignmentsTableModel.down(nRowIndex);
                this.m_assignmentsTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

